/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.message;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * @author Vu Le
 * @version 1.0
 */
public class ORUZ11MessageTest extends AbstractMessagingTest {

   /**
    * @param name
    */
   public ORUZ11MessageTest(String name) {
      super(name);
   }

   public void testORUZ11() throws Exception {
      BatchMessage inbound = new BatchMessage( createTestMessageFromFile( ORUZ07_FILE ) );
      Log logger = getLogger();
      if( logger.isDebugEnabled() ) {
         logger.debug( "In bound Message data: " + inbound.getMessageData() );
         logger.debug( "In bound Facility " + inbound.getReceivingFacility() );
      }
      
      /*
      BHS^~|\&^VAMC 605^605^HEC 605^724^20040810161304-0500^^~T~ORU|Z07~2.1~AL~AL^^6058083426^
      */
      ArrayList elements = new ArrayList();
      elements.add( "~|\\&");
      elements.add( "VAMC 605");
      elements.add( "605");
      elements.add( "HEC 605");
      elements.add( "724");
      elements.add( "20040810161304-0500");
      elements.add( null );
      elements.add( "~T~ORU|Z07~2.1~AL~AL");
      elements.add( "null" );
      elements.add( "6058083426" );
      
      Segment header = new Segment( SegmentConstants.BHS, elements );
      
      ArrayList segments = new ArrayList();
      segments.add( header );
      
      BatchMessage outbound = new BatchMessage( segments, "ORUZ07" );
      if( logger.isDebugEnabled() ) {
         logger.debug( "Message data: " + outbound.getMessageData() );
         logger.debug( "Facility " + outbound.getReceivingFacility() );
      }
      
      assertNotNull( "Message must not be null", inbound );
      assertNotNull( "Message must not be null", outbound );
      assertNotSame( "Facility element of inbound and outbound messages are not equal", inbound, outbound );
   }
}
