package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.fw.hl7.Message;

/**
 * 
 * @author Rajiv Patnaik Created on Jul 27, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORUZ11BuilderTest extends AbstractSegmentBuilderTest
{

    /**
     * Constructor for ORUZ11BuilderTest.
     * 
     * @param testName
     * @throws Exception
     */
    public ORUZ11BuilderTest(String testName) throws Exception
    {
        super(testName);
    }

    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testBuild() throws Exception
    {
        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("71954"));
         
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ11Builder builder = (ORUZ11Builder) applicationContext.getBean("outbound.oruz11Builder");

        Message message = builder.build(person, siteIdentity);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
    }

    public SiteIdentity createSiteIdentity(Person person) throws Exception
    {
        SiteIdentity si = new SiteIdentity();

        si.setPerson(person);
        VAFacility facility = getLookupService().getVaFacilityByStationNumber(
                VAFacility.CODE_HEC.getName());
        si.setVaFacility(facility);
        return si;
    }
}