package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.fw.hl7.Message;


/**
 * 
 * @author Rajiv Patnaik
 * Created on Jan 9, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORUZ10BuilderTest extends AbstractSegmentBuilderTest
{

    /**
     * @param testName
     * @throws Exception
     */
    public ORUZ10BuilderTest(String testName) throws Exception
    {
        super(testName);
    }
    
    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testBuild() throws Exception
    {

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("20696344"));  
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ10Builder z10Builder = (ORUZ10Builder) this.applicationContext
                .getBean("outbound.oruz10Builder");

        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.RESPOND,
                PersonTrigger.DataType.FINANCIAL);

        incomeYearTriggerEvent.setIncomeYear(Integer.valueOf("2006")); 
        
        Object[] args = new Object[] { person, siteIdentity,
                null, incomeYearTriggerEvent };
        Message message = z10Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
    }        

}
