package gov.va.med.esr.messaging.builder.message;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZMT;

/**
 * Tests the outbound ORUZ06Builder
 * 
 * @author Rajiv Patnaik
 * Created on Jan 17, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORUZ06BuilderTest extends AbstractSegmentBuilderTest
{

    /**
     * @param testName
     * @throws Exception
     */
    public ORUZ06BuilderTest(String testName) throws Exception
    {
        super(testName);
    }
    
    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testBuild() throws Exception
    {
    	PersonIdEntityKeyImpl personKey = new PersonIdEntityKeyImpl(new BigDecimal("373971922"));

        Person person = getPersonService().getPerson(personKey);
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ06Builder z06Builder = (ORUZ06Builder) this.applicationContext
                .getBean("outbound.oruz06Builder");

        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.NOTIFY,
                PersonTrigger.DataType.MEANS_TEST);
        incomeYearTriggerEvent.setIncomeYear(Integer.valueOf("2009"));
        incomeYearTriggerEvent.setActionCode("C");
        incomeYearTriggerEvent.setType("MT");
        
        //Set sites = new HashSet();
        //sites.add(siteIdentity.getVaFacility());        
        //incomeYearTriggerEvent.setTargetSites(sites);

 
        Object[] args = new Object[] { person, siteIdentity,
                null, incomeYearTriggerEvent };
        Message message = z06Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
        
        PID pid = (PID) message.getSegment("PID");
        assertNotNull("PID is null", pid);
        
        ZMT zmt = (ZMT) message.getSegment("ZMT");
        assertNotNull("ZMT is null", zmt);
        
        System.out.println("The Z06 message: " + message);

     
       }            

}
