package gov.va.med.esr.messaging.builder.message;

import java.util.HashSet;
import java.util.Set;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.PartialPersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.TargetedPersonTriggerEvent;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.PID;

/**
 * Tests the outgoing ORUZ05 message builder
 * 
 * @author Rajiv Patnaik Created on Sep 8, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORUZ05BuilderTest extends AbstractSegmentBuilderTest
{
    /**
     * Constructor for OutboundORUZ04BuilderTest.
     * 
     * @param testName
     * @throws Exception
     */
    public ORUZ05BuilderTest(String testName) throws Exception
    {
        super(testName);
    }
 
    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testAddressBuilder() throws Exception
    {

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("1009"));
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ05Builder z05Builder = (ORUZ05Builder) this.applicationContext.getBean("outbound.oruz05Builder");

        Address address = Address.getAddressOfType(person.getAddresses(),
                AddressType.CODE_PERMANENT_ADDRESS.getCode());
        Set entityKeys = new HashSet();
        entityKeys.add(address.getEntityKey());

        //Test for Address info
        PartialPersonTriggerEvent triggerEvent = new PartialPersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,
                PersonTrigger.DataType.ADDRESS);
        triggerEvent.setPersonId(person.getPersonEntityKey());
        triggerEvent.setEntityKeys(entityKeys);

        Object[] args = new Object[] { person, siteIdentity,
                address.getEntityKey(), triggerEvent };
        Message message = z05Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
        
        PID pid = (PID) message.getSegment("PID");
        assertNotNull("PID is null" + pid);
        assertNotNull("Address is null" + pid.getPatientAddress());
    }
     
    public void testAssociationBuilder() throws Exception
    {
        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("73302"));
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ05Builder z05Builder = (ORUZ05Builder) this.applicationContext
                .getBean("outbound.oruz05Builder");

        Association association = Association.getAssociationOfType(person.getAssociations(),
                AssociationType.CODE_GUARDIAN_CIVIL.getCode());
        Set entityKeys = new HashSet();
        entityKeys.add(association.getEntityKey());

        //Test for Address info
        PartialPersonTriggerEvent triggerEvent = new PartialPersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.NOTIFY,
                PersonTrigger.DataType.GUARDIAN_INFO,
                entityKeys);
                
        triggerEvent.setPersonId(person.getPersonEntityKey());
        triggerEvent.setEntityKeys(entityKeys);

        Object[] args = new Object[] { person, siteIdentity,
                association.getEntityKey(), triggerEvent };
        Message message = z05Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
    }

    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testDODBuilder() throws Exception
    {

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("72912"));
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ05Builder z05Builder = (ORUZ05Builder) this.applicationContext.getBean("outbound.oruz05Builder");

        
        TargetedPersonTriggerEvent triggerEvent = new TargetedPersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.NOTIFY,
                PersonTrigger.DataType.DATE_OF_DEATH);

        triggerEvent.setPersonId(person.getPersonEntityKey());

        Object[] args = new Object[] { person, siteIdentity, null, triggerEvent };
        Message message = z05Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
        
    }    
}