package gov.va.med.esr.messaging.builder.message;

import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.lookup.InsurancePlanType;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.service.MessageProcessServiceUtil;
import gov.va.med.esr.messaging.xml.XmlFormatter;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.model.EntityKey;

/**
 * 
 * @author Rajiv Patnaik Created on Sep 1, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORUZ04BuilderTest extends AbstractSegmentBuilderTest
{
    /**
     * Constructor for OutboundORUZ04BuilderTest.
     * 
     * @param testName
     * @throws Exceptiono
     */
    public ORUZ04BuilderTest(String testName) throws Exception
    {
        super(testName);
    }

    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testBuild() throws Exception 
    {

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("2"));  
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORUZ04Builder z04Builder = (ORUZ04Builder) applicationContext.getBean("outbound.oruz04Builder");
        
        Set insurances = person.getInsurances();
        EntityKey medicareEntityKey = null;
        
        for (Iterator iter = insurances.iterator(); iter.hasNext();)
        {
            InsurancePolicy policy = (InsurancePolicy) iter.next();
            if (policy instanceof Medicare)
            {
                medicareEntityKey = policy.getEntityKey();
            }
        }
        
        Message message = z04Builder.build(person, siteIdentity, medicareEntityKey);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
    }

}