package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.TargetedPersonTriggerEvent;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.PID;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * 
 * @author Rajiv Patnaik Created on Jan 11, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORFZ11BuilderTest extends AbstractSegmentBuilderTest
{

    /**
     * @param testName
     * @throws Exception
     */
    public ORFZ11BuilderTest(String testName) throws Exception
    {
        super(testName);
    }

    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testBuild() throws Exception
    {

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("72996"));
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORFZ11Builder z11Builder = (ORFZ11Builder) this.applicationContext
                .getBean("outbound.orfz11Builder");

        TargetedPersonTriggerEvent targetedPersonTriggerEvent = new TargetedPersonTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.RESPOND,
                PersonTrigger.DataType.ELIGIBILITY);
        Set sites = new HashSet();

        IncomingMessageInfo incomingMessageInfo = new IncomingMessageInfo();
        incomingMessageInfo.setReferenceMessageId("212121");
        incomingMessageInfo.setSendingFacility(siteIdentity.getVaFacility());
        incomingMessageInfo.setQueryDateTime(new Date());

        targetedPersonTriggerEvent.setIncomingMessageInfo(incomingMessageInfo);
        sites.add(siteIdentity.getVaFacility());
        targetedPersonTriggerEvent.setTargetSites(sites);

        Object[] args = new Object[] { person, siteIdentity, null,
                targetedPersonTriggerEvent };

        Message message = z11Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());

        PID pid = (PID) message.getSegment("PID");
        assertNotNull("PID is null" + pid);

    }
}