package gov.va.med.esr.messaging.builder.message;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;

import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.PID;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * Tests the builder for the outgoing ORFZ10 message
 * 
 * @author Rajiv Patnaik
 * Created on Jan 6, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class ORFZ10BuilderTest extends AbstractSegmentBuilderTest
{

    /**
     * @param testName
     * @throws Exception
     */
    public ORFZ10BuilderTest(String testName) throws Exception
    {
        super(testName);
    }

    /*
     * Class under test for Message build(Person, SiteIdentity)
     */
    public void testBuild() throws Exception
    {

        Person person = getPersonService().getPerson(
                CommonEntityKeyFactory.createPersonIdEntityKey("4525"));
        SiteIdentity siteIdentity = createSiteIdentity(person);

        ORFZ10Builder z10Builder = (ORFZ10Builder) this.applicationContext.getBean("outbound.orfz10Builder");

        IncomeYearTriggerEvent incomeYearTriggerEvent = new IncomeYearTriggerEvent(
                PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA,
                PersonTrigger.DispatchType.RESPOND,
                PersonTrigger.DataType.FINANCIAL);
        Set sites = new HashSet();

        incomeYearTriggerEvent.setIncomeYear(Integer.valueOf("2003"));
        
        IncomingMessageInfo incomingMessageInfo = new IncomingMessageInfo(); 
        incomingMessageInfo.setReferenceMessageId("gjhhg");
        incomingMessageInfo.setSendingFacility(siteIdentity.getVaFacility());
        incomingMessageInfo.setQueryDateTime(new Date());
        
        incomeYearTriggerEvent.setIncomingMessageInfo(incomingMessageInfo);
        sites.add(siteIdentity.getVaFacility());        
        incomeYearTriggerEvent.setTargetSites(sites);
        
 
        Object[] args = new Object[] { person, siteIdentity,
                null, incomeYearTriggerEvent };
        Message message = z10Builder.build(args);

        assertNotNull("Message from builder is null", message);
        assertNotNull("Message from builder is null", message.getMessageData());
        System.out.println(message.getMessageData());
        
        PID pid = (PID) message.getSegment("PID");
        assertNotNull("PID is null" + pid);


    }    
}
