/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.Calendar;

//Library Classes

//Framework Classes
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.hl7.segment.MSH;

//EDB Classes
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;

import gov.va.med.esr.messaging.builder.message.MSHBuilder;
import gov.va.med.esr.messaging.builder.message.MSHMetaData;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class MSHBuilderTest extends AbstractMessagingTest {
	
	/**
     * Constructor for MSHBuilderTest.
     * 
     * @param testName
     */    
    public MSHBuilderTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.MSHBuilder.
     */
    public void testMSHBuilder() throws Exception {
    	logger.info("testMSHBuilder");
    	
    	MSHMetaData metaData = new MSHMetaData((AbstractEntity)null);
    	metaData.setControlID("12345");
    	Calendar cal = Calendar.getInstance();
    	cal.set(2004, 9, 9, 13, 59, 59);
    	metaData.setCreationDatetime(cal.getTime());
    	metaData.setMessageType(HL7Constants.ORUZ07);
    	metaData.setReceivingApplication("VAMC 605");
    	metaData.setReceivingFacility("605");
    	metaData.setApplicationACKType(HL7Constants.APPLICATION_ACK_TYPE_NE);
    	
    	MSHBuilder builder = (MSHBuilder)applicationContext.getBean("outbound.mshBuilder");
    	MSH segment = (MSH)builder.build(metaData);
    	    	
    	super.assertEquals("Segment Name Match", SegmentConstants.MSH, segment.getName());
    	super.assertEquals("Element Data Match", "^~|\\&^HEC 605^724^VAMC 605^605^20041009135959^^ORU~Z07^12345^T^2.3.1^^^AL^NE^USA", segment.getElementData());
    	super.assertEquals("Receiving Facility Match", "605", segment.getElements().get(5) );
    }
}