/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;


//Framework Classes
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.hl7.segment.MSA;

//EDB Classes
import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.messaging.builder.message.MSABuilder;
import gov.va.med.esr.messaging.builder.message.MSAMetaData;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class MSABuilderTest extends AbstractMessagingTest {
	private static final String CONTROL_ID = "12345";
	private static final String ERROR_DESC = "Date of Death must be after the Veteran Date of Birth";
	
	/**
     * Constructor for MSABuilderTest.
     * 
     * @param testName
     */    
    public MSABuilderTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.MSABuilder.
     */
    public void testMSABuilder() throws Exception {
    	logger.info("testMSABuilder");
    	
    	MSAMetaData metaData = new MSAMetaData((AbstractEntity)null);
    	metaData.setACKCode(AckType.CODE_AE.getName());
    	metaData.setControlID(CONTROL_ID);
    	metaData.setTextMessage(ERROR_DESC);
    	
    	MSABuilder builder = (MSABuilder)applicationContext.getBean("outbound.msaBuilder");
    	MSA segment = (MSA)builder.build(metaData);
    	    	
    	super.assertEquals("Segment Name Match", SegmentConstants.MSA, segment.getName());
    	super.assertEquals("AE Match", AckType.CODE_AE.getName(), segment.getElements().get(0) );
    	super.assertEquals("Control ID Match", CONTROL_ID, segment.getElements().get(1) );
    	super.assertEquals("Error Match", ERROR_DESC, segment.getElements().get(2) );
    	super.assertEquals("Element Data Match", "^AE^12345^Date of Death must be after the Veteran Date of Birth", segment.getElementData());
    }
}