/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Library Classes

//Framework Classes
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.hl7.segment.BTS;

//EDB Classes
import gov.va.med.esr.messaging.builder.message.BTSBuilder;
import gov.va.med.esr.messaging.builder.message.BTSMetaData;

import gov.va.med.esr.messaging.util.AbstractMessagingTest;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class BTSBuilderTest extends AbstractMessagingTest {
	/**
     * Constructor for BTSBuilderTest.
     * 
     * @param testName
     */    
    public BTSBuilderTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.BTSBuilder.
     */
    public void testMSABuilder() throws Exception {
    	logger.info("testBTSBuilder");
    	
    	BTSMetaData metaData = new BTSMetaData((AbstractEntity)null);
    	int count = 1;
    	metaData.setMessageCount(count);
    	
    	BTSBuilder builder = (BTSBuilder)applicationContext.getBean("outbound.btsBuilder");
    	BTS segment = (BTS)builder.build(metaData);

    	super.assertEquals("Segment Name Match", SegmentConstants.BTS, segment.getName());
    	super.assertEquals("Count Match", String.valueOf(count), segment.getElements().get(0));
    	super.assertEquals("Element Data Match", "^1", segment.getElementData());
    }
}