/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.Calendar;

import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.model.AbstractEntity;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class BHSBuilderTest extends AbstractMessagingTest {
	/**
     * Constructor for BHSBuilderTest.
     * 
     * @param testName
     */    
    public BHSBuilderTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.BHSBuilder.
     */
    public void testBHSBuilder() throws Exception {
    	logger.info("testBHSBuilder");
    	
    	BHSMetaData metaData = new BHSMetaData((AbstractEntity)null);
    	metaData.setComment(AckType.CODE_AA.getName());
    	metaData.setControlID("12345");
    	Calendar cal = Calendar.getInstance();
    	cal.set(2004, 9, 9, 13, 59, 59);
    	metaData.setCreationDatetime(cal.getTime());
    	metaData.setMessageType(HL7Constants.ORUZ07);
    	metaData.setReceivingApplication("VAMC 605");
    	metaData.setReceivingFacility("605");
    	
    	BHSBuilder builder = (BHSBuilder)applicationContext.getBean("outbound.bhsBuilder");
    	BHS segment = (BHS)builder.build(metaData);
    	    	
    	super.assertEquals("Segment Name Match", SegmentConstants.BHS, segment.getName());
    	super.assertEquals("Element Data Match", "^~|\\&^HEC 605^724^VAMC 605^605^20041009135959^^~T~ORU|Z07~2.3.1~AL~AL^AA^12345^", segment.getElementData());
    	super.assertEquals("Receiving Facility Match", "605", segment.getElements().get(5) );
    }
}