/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//EDB Classes
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;
import gov.va.med.esr.service.LookupService;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class AbstractSegmentBuilderTest extends AbstractMessagingTest {
    private static final String codeWithZero = "01";
    private static final String codeTen = "10";
    private static final String codeWithoutZero = "11";
    
    private LookupService lkService;
	private MessageLookupBuilder builder;
	private EligibilityType type;
	private String result;
    
    /**
     * Constructor for AbstractSegmentBuilderTest.
     * 
     * @param testName
     */    
    public AbstractSegmentBuilderTest(String testName) throws Exception {
        super(testName);
    }
    
    protected void customSetUp() throws Exception {
        super.customSetUp();
                
        this.lkService = (LookupService)applicationContext.getBean("lookupService");
        this.builder = new MessageLookupBuilder();
    	this.type = null;
    	this.result = null;
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.AbstractSegmentBuilder.
     */
//    public void testBuilderZeroOne() throws Exception {
//    	logger.info("testBuilderZeroOne");
//    	
//    	type = (EligibilityType)lkService.getByCode(EligibilityType.class, EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getName());
//    	result = builder.build(type);
//    	super.assertEquals("01 Match", "1", result);
//    }
//    
//    public void testBuilderTen() throws Exception {
//    	logger.info("testBuilderTen");
//    	
//    	type = (EligibilityType)lkService.getByCode(EligibilityType.class, codeTen);
//    	result = builder.build(type);
//    	super.assertEquals("10 Match", "10", result);
//    }
//    
//    public void testBuilderEleven() throws Exception {
//    	logger.info("testBuilderEleven");
//    	
//    	type = (EligibilityType)lkService.getByCode(EligibilityType.class, codeWithoutZero);
//    	result = builder.build(type);
//    	super.assertEquals("11 Match", "11", result);
//    }
//     
    private static class MessageLookupBuilder extends AbstractSegmentBuilder {

        private static final long serialVersionUID = -4523465411082314703L;
        
    }
}
