/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.builder.message;

//Java Classes
import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.constants.SegmentConstants;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.esr.messaging.constants.HL7Constants;
import gov.va.med.esr.messaging.util.AbstractMessagingTest;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class ACKBuilderTest extends AbstractMessagingTest {
    /**
     * Constructor for ACKBuilderTest.
     * 
     * @param testName
     */    
    public ACKBuilderTest(String testName) throws Exception {
        super(testName);
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.ACKBuilder.
     */
    public void testACKBuilderAA() throws Exception {
    	logger.info("testACKBuilderAA");
    	    	
    	Message msg = super.createORUZ07Message();
    	
    	ACKBuilder builder = (ACKBuilder)applicationContext.getBean("outbound.ackBuilder");
    	Message ack = (Message)builder.build(msg);
    	
    	super.assertEquals("BatchMessage Instance Check", true, (ack instanceof BatchMessage));
    	    	    	
    	BatchMessage ackBatch = (BatchMessage)ack;
	    Message ackMessage = (Message)ackBatch.getMessages().get(0);
	    
    	super.assertEquals("Batch Message Type Match", HL7Constants.ACK, ackBatch.getType());
    	super.assertEquals("Batch Control ID Match", "A54364365", ackBatch.getMessageID());
    	super.assertEquals("Message Type Match", HL7Constants.ACK, ackMessage.getMessageType());
    	super.assertEquals("Message Control ID Match", "A54364365", ackMessage.getMessageID());
    	super.assertEquals("MSA ACK Type Match", AckType.CODE_AA.getName(), ackMessage.getSegment(SegmentConstants.MSA).getElements().get(0));
    	super.assertEquals("MSA Control ID Match", "54364365", ackMessage.getSegment(SegmentConstants.MSA).getElements().get(1));
    }
    
    /**
     * Test of Build method, of class gov.va.med.esr.messaging.builder.ACKBuilder.
     */
    public void testACKBuilderAE() throws Exception {
    	logger.info("testACKBuilderAE");
    	
    	LookupsDAO  vaFacilityDAO = null;
        LookupsDAO messageStatusDAO = null;
        LookupsDAO messageTypeDAO = null;
    	MessageType mt = null;
	    MessageStatus ms = null;
	    VAFacility va = null;
    	
    	Message msg = super.createORUZ07Message();
    	
    	//Create Message Log object
	    va = getLookupService().getVaFacilityByCode("655");
    	mt = getLookupService().getMessageTypeByCode("ORUZ07-E");
    	ms = getLookupService().getMessageStatusByCode(MessageStatus.AWAITING_TRANSMISSION);

    	//MessageLogEntry log = new MessageLogEntry(mt ,ms, null, va, msg.getMessageData());
    	MessageLogEntry log = new MessageLogEntry();
    	log.setType(mt);
    	log.setStatus(ms);
    	log.setVaFacility(va);
    	log.setBody(msg.getMessageData());
    	
    	log.setAckType(getLookupService().getAckTypeByCode(AckType.CODE_AE));
    	log.setErrorText("Error Description");
    	log.setControlIdentifier("60513942247-1");
    	
    	ACKBuilder builder = (ACKBuilder)applicationContext.getBean("outbound.ackBuilder");
    	    	
    	List errors = new ArrayList();
    	errors.add(log);
    	
    	//Create AE ACK
    	Message ack = builder.build(msg, errors);
    	
    	super.assertEquals("BatchMessage Instance Check", true, (ack instanceof BatchMessage));
    	
		BatchMessage ackBatch = (BatchMessage)ack;
		Message ackMessage = (Message)ackBatch.getMessages().get(0);
		
		super.assertEquals("Batch Message Type Match", HL7Constants.ACK, ackBatch.getType());
		super.assertEquals("Batch Control ID Match", "A54364365", ackBatch.getMessageID());
		super.assertEquals("Message Type Match", "ORU~Z07", ackMessage.getMessageType());
		super.assertEquals("Message Control ID Match", "60513942247-1", ackMessage.getMessageID());
		super.assertEquals("MSA ACK Type Match", AckType.CODE_AE.getName(), ackMessage.getSegment(SegmentConstants.MSA).getElements().get(0));
		super.assertEquals("MSA Control ID Match", "60513942247-1", ackMessage.getSegment(SegmentConstants.MSA).getElements().get(1)); 
		super.assertEquals("MSA Error Match", "Error Description", ackMessage.getSegment(SegmentConstants.MSA).getElements().get(2));
    }
}