/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity.lookup;

// Java Classes
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.impl.LookupServiceImpl;
import gov.va.med.fw.model.lookup.AbstractLookup;

import java.util.List;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class MockLookupServiceWithException
	extends LookupServiceImpl
    implements LookupService
{
    private boolean throwUnknownLookupCodeException = false;
    private boolean throwUnknownLookupTypeException = false;
    private String throwCodeExceptionOn = null;

    public MockLookupServiceWithException(
        boolean throwUnknownLookupTypeException,
        boolean throwUnknownLookupCodeException)
    {
        super();

        this.throwUnknownLookupCodeException = throwUnknownLookupCodeException;
        this.throwUnknownLookupTypeException = throwUnknownLookupTypeException;
    }

    public MockLookupServiceWithException(
        boolean throwUnknownLookupTypeException,
        boolean throwUnknownLookupCodeException,
        String throwCodeExceptionOn)
    {
        super();

        this.throwUnknownLookupCodeException = throwUnknownLookupCodeException;
        this.throwUnknownLookupTypeException = throwUnknownLookupTypeException;
        this.throwCodeExceptionOn = throwCodeExceptionOn;
    }

    public List findAll(Class lookupType) throws UnknownLookupTypeException
    {
        if(this.throwUnknownLookupTypeException)
        {
            throw new UnknownLookupTypeException("", lookupType);
        }
        else
        {
            return null;
        }
    }

    public AbstractLookup getByCode(Class lookupType, String code)
        throws UnknownLookupTypeException,
        UnknownLookupCodeException
    {
        if(this.throwUnknownLookupTypeException)
        {
            throw new UnknownLookupTypeException("", lookupType);
        }
        else if((this.throwUnknownLookupCodeException)
            && throwCodeExceptionOn.equals(code))
        {
            throw new UnknownLookupCodeException("", code, lookupType);
        }
        else
        {
            return new MockLookup("99", null);
        }
    }
}