/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity.lookup;

// Java Classes
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.impl.LookupServiceImpl;
import gov.va.med.fw.model.lookup.AbstractLookup;

import java.util.List;

import junit.framework.Assert;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class MockLookupService 
	extends LookupServiceImpl
    implements LookupService
{
    private Class expectedLookupType;
    private List findAllResults;

    public MockLookupService(Class expectedLookupType, List findAllResults)
    {
        super();

        this.expectedLookupType = expectedLookupType;
        this.findAllResults = findAllResults;
    }

    public List findAll(Class lookupType) throws UnknownLookupTypeException
    {
        Assert.assertEquals(expectedLookupType, lookupType);
        return this.findAllResults;
    }

    public AbstractLookup getByCode(Class lookupType, String code)
        throws UnknownLookupTypeException,
        UnknownLookupCodeException
    {
        Assert.assertEquals(expectedLookupType, lookupType);
        return new MockLookup(code, "");
    }
}