/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity.lookup;

// Java Classes
import java.util.HashMap;

// Library Classes
import junit.framework.TestCase;

// Framework Classes
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.builder.entity.lookup.MappedLookupBuilder;
import gov.va.med.esr.common.builder.entity.lookup.PartiallyMappedLookupBuilder;
import gov.va.med.esr.common.builder.entity.lookup.PartiallyMappedLookupDescriptionBuilder;
import gov.va.med.esr.common.builder.entity.lookup.UnmappedLookupBuilder;

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class LookupBuilderTest
    extends TestCase
{
    private MappedLookupBuilder mappedBuilder;
    private PartiallyMappedLookupBuilder partiallyMappedBuilder;
    private PartiallyMappedLookupDescriptionBuilder partiallyMappedDescriptionBuilder;
    private UnmappedLookupBuilder unmappedBuilder;

    public LookupBuilderTest(String name)
    {
        super(name);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        super.setUp();

        this.mappedBuilder = new MappedLookupBuilder();
        this.mappedBuilder.setLookupType(MockLookup.class);

        this.partiallyMappedBuilder = new PartiallyMappedLookupBuilder();
        this.partiallyMappedBuilder.setLookupType(MockLookup.class);

        this.partiallyMappedDescriptionBuilder = new PartiallyMappedLookupDescriptionBuilder();
        this.partiallyMappedDescriptionBuilder.setLookupType(MockLookup.class);

        this.unmappedBuilder = new UnmappedLookupBuilder();
        this.unmappedBuilder.setLookupType(MockLookup.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception
    {
        this.mappedBuilder = null;
        this.partiallyMappedBuilder = null;
        this.partiallyMappedDescriptionBuilder = null;
        this.unmappedBuilder = null;

        super.tearDown();
    }

    public void testMappedBuilder_HandleServiceUnknownLookupTypeException()
        throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode(null);
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupServiceWithException(
            true, false));

        try
        {
            this.mappedBuilder.build("X");
            super.fail();
        }
        catch(BuilderException e)
        {
        }
    }

    public void testMappedBuilder_HandleServiceUnknownLookupCodeException()
        throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode(null);
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupServiceWithException(
            false, true, "Y"));

        try
        {
            this.mappedBuilder.build("X");
            super.fail();
        }
        catch(BuilderException e)
        {
        }
    }

    public void testMappedBuilder_TranslateKnownCode() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode(null);
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build("X");
        super.assertEquals("Y", lookup.getCode());
    }

    public void testMappedBuilder_TranslateUnknownCode() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode(null);
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build("Z");
        super.assertNull(lookup);
    }

    public void testMappedBuilder_TranslateNull() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode(null);
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build(null);
        super.assertNull(lookup);
    }

    public void testMappedBuilder_HandleServiceUnknownLookupTypeException_WithDefaultOnNull()
        throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(true);
        this.mappedBuilder.setLookupService(new MockLookupServiceWithException(
            true, false));

        try
        {
            this.mappedBuilder.build("X");
            super.fail();
        }
        catch(BuilderException e)
        {
        }
    }

    public void testMappedBuilder_HandleServiceUnknownLookupCodeException_WithDefaultOnNull()
        throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(true);
        this.mappedBuilder.setLookupService(new MockLookupServiceWithException(
            false, true, "Y"));

        try
        {
            this.mappedBuilder.build("X");
            super.fail();
        }
        catch(BuilderException e)
        {
        }
    }

    public void testMappedBuilder_TranslateKnownCode_WithDefaultOnNull() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(true);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build("X");
        super.assertEquals("Y", lookup.getCode());
    }

    public void testMappedBuilder_TranslateUnknownCode_WithDefaultOnNull() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(true);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build("Z");
        super.assertEquals("99", lookup.getCode());
    }

    public void testMappedBuilder_TranslateNull_WithDefaultOnNull() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(false);
        this.mappedBuilder.setDefaultOnNull(true);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build(null);
        super.assertEquals("99", lookup.getCode());
    }

    public void testMappedBuilder_HandleServiceUnknownLookupTypeException_WithDefaultOnException()
        throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(true);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupServiceWithException(
            true, false));

        try
        {
            this.mappedBuilder.build("X");
            super.fail();
        }
        catch(BuilderException e)
        {
        }
    }

    public void testMappedBuilder_HandleServiceUnknownLookupCodeException_WithDefaultOnException()
        throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(true);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupServiceWithException(
            false, true, "Y"));

        AbstractLookup lookup = this.mappedBuilder.build("X");
        super.assertEquals("99", lookup.getCode());
    }

    public void testMappedBuilder_TranslateKnownCode_WithDefaultOnException() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(true);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build("X");
        super.assertEquals("Y", lookup.getCode());
    }

    public void testMappedBuilder_TranslateUnknownCode_WithDefaultOnException() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(true);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build("Z");
        super.assertNull(lookup);
    }

    public void testMappedBuilder_TranslateNull_WithDefaultOnException() throws Exception
    {
        HashMap codeMap = new HashMap();
        codeMap.put("X", "Y");
        this.mappedBuilder.setCodeMap(codeMap);
        this.mappedBuilder.setDefaultCode("99");
        this.mappedBuilder.setDefaultOnException(true);
        this.mappedBuilder.setDefaultOnNull(false);
        this.mappedBuilder.setLookupService(new MockLookupService(
            MockLookup.class, null));

        AbstractLookup lookup = this.mappedBuilder.build(null);
        super.assertNull(lookup);
    }

    public void test() throws Exception
    {

    }

    /*
     * public void test() throws Exception { }
     */
}