/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import junit.framework.TestCase;

import gov.va.med.esr.common.builder.entity.ImpreciseDateBuilder;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.persistent.hibernate.CombinedImpreciseDateType;

/**
 * Initial javadoc for class TestImpreciseDateBuilder.
 * TODO - Add content here
 * 
 * Created Aug 4, 2005 12:59:32 PM
 * @author DNS   bohmeg
 */
public class TestImpreciseDateBuilder extends TestCase {
	
    private static String escapeRegExprChars(String name) {
  	   if (name == null) {
  		   return null;
  	   }
         StringBuffer sb = new StringBuffer();
         for (int i = 0; i < name.length(); i++) {
             char curChar = name.charAt(i);
             switch (curChar) {
                 case '\\': 
                 case '/':
                 case ',':
                 case '.':
                 case '+':
                 case '-':
                 case '"':
                 case '@':
                 case '!':
                 case '?':
                 case '<':
                 case '>':
                 case '(':
                 case ')':  
                 case '[':
                 case ']': 
                 case '{':
                 case '}':                 	 
                 case ';':
                 case ':':
                 case '^':
                 case '$':
                 case '*':
              	   break;
                 default:
                     sb.append(curChar);
             }
         }       
         return sb.toString();
     }
    
    public void testFortify() throws Exception {
    	String subject = "^([0-9a-zA-Z]([-.]*[0-9a-zA-Z])*@(([0-9a-zA-Z])+([-]*[0-9a-zA-Z])*.)+[a-zA-Z]{2,9})$";
    	
    	String filteredSubject = subject;
    	if (StringUtils.isNotEmpty(subject)) {
    		filteredSubject = escapeRegExprChars(subject);
    	}
    	System.out.println(subject + "\n\n" + filteredSubject);
    	subject = null;
    	filteredSubject = escapeRegExprChars(subject);
    	System.out.println("\n\n"+subject + "\n\n" + filteredSubject);
    	
    }
    
    public void testFortify2() throws Exception {
    	String subject = "Congratulations!! You won the lottery!!!\r\ncc:victim1@mail.com,\nvictim2@mail.com ...";
    	
    	String filteredSubject = subject;
    	if (StringUtils.isNotEmpty(subject)) {
    		filteredSubject = filteredSubject.replace("\r", "");
    		filteredSubject = filteredSubject.replace("\n", "");
    	}
    	System.out.println(subject + "\n\n" + filteredSubject);
    }
    
	public void testBuilding() throws Exception {
		ImpreciseDateBuilder builder = new ImpreciseDateBuilder();
		
		ImpreciseDate date = null;
		String databaseValue = null;
		ImpreciseDate fromDatabase = null;
		String[] dates = { "2005", "200512", "20051201", "20050702153018.2245-0200", "20050702153018.2245-0400", "20051117174839-0500",
				"20050817174839-0500", "20030904121212-0800",  "20051117174839-0400"};
		for(int i=0; i <dates.length ; i++) {
			System.out.println("****String input: " + dates[i]);
			date = builder.build(dates[i]);
			System.out.println("ImpreciseDate object: " + date);
			System.out.println("ImpreciseDate.getDate(): " + date.getDate());
			System.out.println("ImpreciseDate.getCalendar(): " + date.getCalendar());
			if(date.isPrecise()) {
				System.out.println("ImpreciseDate.getDate(), custom format: " + (new SimpleDateFormat("yyyyMMddHHmmssZ")).format(date.getDate()));
			}
			databaseValue = toDatabaseValue(date);
			System.out.println("Database value: " + databaseValue);
			fromDatabase = fromDatabaseValue(databaseValue);
			System.out.println("ImpreciseDate from Database value: " + fromDatabase);
			if(fromDatabase.isPrecise())
				System.out.println("ImpreciseDate formatted for output: " + (new SimpleDateFormat("yyyyMMddHHmmssZ")).format(fromDatabase.getDate()));
		}
	}
	
	private String toDatabaseValue(ImpreciseDate date) {
		return CombinedImpreciseDateType.toDatabaseValue(date);
	}

	private ImpreciseDate fromDatabaseValue(String date) throws ParseException {
		return CombinedImpreciseDateType.fromDatabaseValue(date);
	}	
}
