/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.messaging.builder.entity;

// Java Classes

// Library Classes
import junit.framework.Assert;

// Framework Classes
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

// Common Classes

/**
 * @author Martin Francisco
 */
public class MockStringToObjectBuilder implements Builder {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2614852659227121556L;

	private String[] expectedValues;

	private int[] expectedCounts;

	private int[] actualCounts;

	public MockStringToObjectBuilder() {
		super();

		this.expectedValues = new String[0];
		this.expectedCounts = new int[0];
		this.actualCounts = new int[expectedCounts.length];
	}

	public MockStringToObjectBuilder(String expectedValue, int expectedCount) {
		super();

		this.expectedValues = new String[] { expectedValue };
		this.expectedCounts = new int[] { expectedCount };
		this.actualCounts = new int[expectedCounts.length];
	}

	public MockStringToObjectBuilder(String[] expectedValues,
			int[] expectedCounts) {
		super();

		this.expectedValues = (expectedValues == null) ? new String[0]
				: expectedValues;
		this.expectedCounts = (expectedCounts == null) ? new int[0]
				: expectedCounts;
		this.actualCounts = new int[expectedCounts.length];
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.util.builder.Builder#build(java.lang.Object)
	 */
	public Object build(Object input) throws BuilderException {
		String inputString = (String) input;
		boolean found = false;

		for (int index = 0; !found && (index < this.expectedValues.length); index++) {
			String expectedValue = this.expectedValues[index];

			if (((expectedValue == null) && (inputString == null))
					|| expectedValue.equals(inputString)) {
				found = true;
				this.actualCounts[index]++;
			}
		}

		if (!found) {
			Assert.fail("Unexpected Value");
		}

		return null;
	}

	public boolean wasCalledWithExpectedValues() {
		boolean calledWithExpectedValues = true;

		for (int index = 0; calledWithExpectedValues
				&& (index < this.actualCounts.length); index++) {
			calledWithExpectedValues = (this.actualCounts[index] == this.expectedCounts[index]);
		}

		return calledWithExpectedValues;
	}
}