/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity;

// Java Classes

// Library Classes

// Framework Classes
//import gov.va.med.fw.hl7.segment.ZIE;

// Common Classes
import gov.va.med.esr.common.model.ee.IneligibilityFactor;

import gov.va.med.esr.common.builder.entity.DateBuilder;
import gov.va.med.esr.common.builder.entity.IneligibilityFactorBuilder;

/**
 * @author Martin Francisco
 */
public class IneligibilityFactorBuilderTest
    extends AbstractBuilderTestCase
{
    private IneligibilityFactorBuilder builder = null;

    private IneligibilityFactor ineligibilityFactor = null;

    public IneligibilityFactorBuilderTest(String name)
    {
        super(name);

        this.builder = new IneligibilityFactorBuilder();
        this.builder.setDateBuilder(new DateBuilder());
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        super.setUp();

        this.ineligibilityFactor = new IneligibilityFactor();
        this.ineligibilityFactor.setIneligibleDate(super
            .getDateFormat()
            .parse("20021015"));
        this.ineligibilityFactor.setReason("XXX");
        this.ineligibilityFactor.setVaroDecision("YYY");
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception
    {
        this.ineligibilityFactor = null;

        super.tearDown();
    }

    public void testBuild_Null_Null() throws Exception
    {
        /*super.assertNull(this.builder
            .build((IneligibilityFactor)null, (ZIE)null));*/
    }

    public void testBuild_Null_Empty() throws Exception
    {
        /*super.assertNull(this.builder.build(null, new ZIE()));*/
    }

    public void testBuild_Null_Existing() throws Exception
    {
        /*IneligibilityFactor result = this.builder.build(null, super.getZIE());

        super.assertNotNull(result);
        super.assertEquals(super.getDateFormat().parse("20041218"), result
            .getIneligibleDate());
        super.assertEquals("SOME RANDOM REASON", result.getReason());
        super.assertEquals("MY DECISIION", result.getVaroDecision());*/
    }

    public void testBuild_Empty_Null() throws Exception
    {
        /*IneligibilityFactor original = new IneligibilityFactor();
        IneligibilityFactor result = this.builder.build(original, null);

        super.assertSame(original, result);
        super.assertNull(result.getIneligibleDate());
        super.assertNull(result.getReason());
        super.assertNull(result.getVaroDecision());*/
    }

    public void testBuild_Empty_Empty() throws Exception
    {
        /*super.assertNull(this.builder
            .build(new IneligibilityFactor(), new ZIE()));*/
    }

    public void testBuild_Empty_Existing() throws Exception
    {
        /*IneligibilityFactor original = new IneligibilityFactor();
        IneligibilityFactor result = this.builder.build(original, super
            .getZIE());

        super.assertSame(original, result);
        super.assertEquals(super.getDateFormat().parse("20041218"), result
            .getIneligibleDate());
        super.assertEquals("SOME RANDOM REASON", result.getReason());
        super.assertEquals("MY DECISIION", result.getVaroDecision());*/
    }

    public void testBuild_Existing_Null() throws Exception
    {
        /*IneligibilityFactor result = this.builder
            .build(this.ineligibilityFactor, null);

        super.assertSame(this.ineligibilityFactor, result);
        super.assertEquals(super.getDateFormat().parse("20021015"), result
            .getIneligibleDate());
        super.assertEquals("XXX", result.getReason());
        super.assertEquals("YYY", result.getVaroDecision());*/
    }

    public void testBuild_Existing_Empty() throws Exception
    {
        /*IneligibilityFactor result = this.builder
            .build(this.ineligibilityFactor, new ZIE());

        super.assertSame(this.ineligibilityFactor, result);
        super.assertEquals(super.getDateFormat().parse("20021015"), result
            .getIneligibleDate());
        super.assertEquals("XXX", result.getReason());
        super.assertEquals("YYY", result.getVaroDecision());*/
    }

    public void testBuild_Existing_Existing() throws Exception
    {
        /*IneligibilityFactor result = this.builder
            .build(this.ineligibilityFactor, super.getZIE());

        super.assertSame(this.ineligibilityFactor, result);
        super.assertEquals(super.getDateFormat().parse("20041218"), result
            .getIneligibleDate());
        super.assertEquals("SOME RANDOM REASON", result.getReason());
        super.assertEquals("MY DECISIION", result.getVaroDecision());*/
    }
}