/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity;

// Java Classes

// Library Classes
import junit.framework.TestCase;

import gov.va.med.esr.common.builder.entity.BooleanBuilder;

// Framework Classes

// Common Classes

/**
 * @author Martin Francisco
 */
public class BooleanBuilderTest
    extends TestCase
{
    private BooleanBuilder builder = null;

    public BooleanBuilderTest(String name)
    {
        super(name);

        this.builder = new BooleanBuilder();
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception
    {
        super.tearDown();
    }

    public void testBuild_Y() throws Exception
    {
        super.assertEquals(Boolean.TRUE, this.builder.build("Y"));
    }

    public void testBuild_N() throws Exception
    {
        super.assertEquals(Boolean.FALSE, this.builder.build("N"));
    }

    public void testBuild_y() throws Exception
    {
        super.assertEquals(Boolean.TRUE, this.builder.build("y"));
    }

    public void testBuild_n() throws Exception
    {
        super.assertEquals(Boolean.FALSE, this.builder.build("n"));
    }

    public void testBuild_1() throws Exception
    {
        super.assertEquals(Boolean.TRUE, this.builder.build("1"));
    }

    public void testBuild_2() throws Exception
    {
        super.assertNull(this.builder.build("2"));
    }

    public void testBuild_0() throws Exception
    {
        super.assertEquals(Boolean.FALSE, this.builder.build("0"));
    }

    public void testBuild_Null() throws Exception
    {
        super.assertNull(this.builder.build(null));
    }

    public void testBuild_Other() throws Exception
    {
        super.assertNull(this.builder.build("X"));
    }
}