/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes
import gov.va.med.esr.common.model.ee.Application;

import gov.va.med.esr.common.builder.entity.ImpreciseDateBuilder;
import gov.va.med.esr.common.builder.entity.ApplicationBuilder;
import gov.va.med.esr.common.builder.entity.ApplicationMetaData;
import gov.va.med.esr.common.builder.entity.DateBuilder;

/**
 * @author Martin Francisco
 */
public class ApplicationBuilderTest
    extends AbstractBuilderTestCase
{
    private ApplicationBuilder builder = null;

    private Application application = null;

    public ApplicationBuilderTest(String name)
    {
        super(name);

        this.builder = new ApplicationBuilder();
        DateBuilder dateBuilder = new DateBuilder();
        dateBuilder.setImpreciseDateBuilder(new ImpreciseDateBuilder());
        this.builder.setDateBuilder(dateBuilder);
        //this.builder.setDateBuilder(new DateBuilder());
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        super.setUp();

        this.application = new Application();
        this.application.setApplicationDate(super
            .getDateFormat()
            .parse("20021015"));
        this.application.setEffectiveDate(super
            .getDateFormat()
            .parse("20021115"));
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception
    {
        this.application = null;

        super.tearDown();
    }

    public void testBuild_Null_Empty() throws Exception
    {
        super.assertNull(this.builder.build(new MockApplicationMetaData()));
    }

    public void testBuild_Null_Existing() throws Exception
    {
        MockApplicationMetaData metaData = new MockApplicationMetaData();
        metaData.setApplicationDate("20041015");
        Application result = this.builder.build(metaData);

        super.assertNotNull(result);
        super.assertEquals(super.getDateFormat().parse("20041015"), result
            .getApplicationDate());
        super.assertNull(result.getEffectiveDate());
    }

    public void testBuild_Empty_Empty() throws Exception
    {
        MockApplicationMetaData metaData = new MockApplicationMetaData();
        metaData.setEntity(new Application());

        super.assertNull(this.builder.build(metaData));
    }

    public void testBuild_Empty_Existing() throws Exception
    {
        Application original = new Application();
        MockApplicationMetaData metaData = new MockApplicationMetaData();
        metaData.setEntity(original);
        metaData.setApplicationDate("20041015");
        Application result = this.builder.build(metaData);

        super.assertSame(original, result);
        super.assertEquals(super.getDateFormat().parse("20041015"), result
            .getApplicationDate());
        super.assertNull(result.getEffectiveDate());
    }

    public void testBuild_Existing_Empty() throws Exception
    {
        MockApplicationMetaData metaData = new MockApplicationMetaData();
        metaData.setEntity(this.application);
        metaData.setApplicationDate(null);
        Application result = this.builder.build(metaData);

        super.assertSame(this.application, result);
        super.assertEquals(super.getDateFormat().parse("20021015"), result
            .getApplicationDate());
        super.assertEquals(super.getDateFormat().parse("20021115"), result
            .getEffectiveDate());
    }

    public void testBuild_Existing_Existing() throws Exception
    {
        MockApplicationMetaData metaData = new MockApplicationMetaData();
        metaData.setEntity(this.application);
        metaData.setApplicationDate("20041015");
        Application result = this.builder.build(metaData);

        super.assertSame(this.application, result);
        super.assertEquals(super.getDateFormat().parse("20041015"), result
            .getApplicationDate());
        super.assertEquals(super.getDateFormat().parse("20021115"), result
            .getEffectiveDate());
    }

    private static class MockApplicationMetaData
        implements ApplicationMetaData
    {
        private Application entity;

        private String applicationDate;
        private String effectiveDate;

        public MockApplicationMetaData()
        {
            super();
        }

        public Application getEntity()
        {
            return this.entity;
        }

        public void setEntity(Application entity)
        {
            this.entity = entity;
        }

        public String getApplicationDate()
        {
            return this.applicationDate;
        }

        public void setApplicationDate(String applicationDate)
        {
            this.applicationDate = applicationDate;
        }

        public String getEffectiveDate()
        {
            return this.effectiveDate;
        }

        public void setEffectiveDate(String effectiveDate)
        {
            this.effectiveDate = effectiveDate;
        }
    }
}