/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.builder.entity;

// Java Classes
import java.text.SimpleDateFormat;
import java.util.List;

// Library Classes
import junit.framework.TestCase;

// Framework Classes
import gov.va.med.fw.hl7.segment.*;

// Common Classes

/**
 * @author Martin Francisco
 */
public abstract class AbstractBuilderTestCase
    extends TestCase
{
    private SimpleDateFormat dateFormat = null;
    private SimpleDateFormat dateTimeFormat = null;

    private PID pid = null;
    private ZEL zel = null;
    private ZEN zen = null;
    private ZIE zie = null;
    private ZPD zpd = null;

    private List zels = null;

    public AbstractBuilderTestCase(String name)
    {
        super(name);

        this.dateFormat = new SimpleDateFormat("yyyyMMdd");
        this.dateTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        super.setUp();

        this.pid = new PID();
        this.pid.setSetID("1");
        this.pid.setPrimaryID("1005138755V628597");
        this.pid.setPatientIdentifierList("7321090~8~M10"); 
        //this.pid.setAlternatePatientID("");
        this.pid.setPatientName("POSEY~WILLIAM~A");
        //this.pid.setMotherMaidenName("");
        this.pid.setDOB("19310803");
        this.pid.setSex("M");
        //this.pid.setPatientAlias("");
        //this.pid.setRace("");
        this.pid.setPatientAddress("PO BOX 161475~\"\"~ALTAMONTE SPGS~FL~32716");
        this.pid.setCountyCode("117");
        this.pid.setHomePhoneNumber("(407)788-0663");
        this.pid.setBusinessPhoneNumber("(407)526-6194");
        //this.pid.setPrimaryLanguage("");
        //this.pid.setMaritalStatus("");
        //this.pid.setReligion("");
        //this.pid.setPatientAccount("");
        this.pid.setSSN("111223335");
        //this.pid.setDriverLicenseNumber("");
        //this.pid.setMotherIdentifier("");
        //this.pid.setEthnicGroup("");
        //this.pid.setBirthPlace("");
        //this.pid.setMultipleBirthIndicator("");
        //this.pid.setBirthOrder("");
        //this.pid.setCitizenship("");
        //this.pid.setVeteranMilitaryStatus("");
        //this.pid.setNationality("");
        //this.pid.setPatientDeathDateTime("");
        //this.pid.setPatientDeathIndicator("");

        this.zel = new ZEL();
        this.zel.setSetID("1");
        this.zel.setEligibilityCode("3");
        //this.zel.setLongID("");
        //this.zel.setShortID("");
        this.zel.setDisabilityRetirementFromMilitary("0");
        this.zel.setClaimFolderNumber("18842124");
        this.zel.setClaimFolderLocation("317ST.PETERSBURG-RO");
        //this.zel.setVeteran("");
        //this.zel.setPatientType("");
        this.zel.setEligibilityStatus("V");
        this.zel.setEligibilityStatusDate("20030324");
        //this.zel.setEligibilityInterimResponse("");
        this.zel.setEligibilityVerificationMethod("VIVA");
        this.zel.setReceivingAABenefits("0");
        this.zel.setReceivingHouseboundBenefits("0");
        this.zel.setReceivingVaPension("0");
        this.zel.setReceivingVaDisability("1");
        this.zel.setAgentOrangeExposure("0");
        this.zel.setRadiationExposure("0");
        this.zel.setEnvironmentalContaminants("0");
        this.zel.setTotalAnnualVaCheckAmount("5340");
        //this.zel.setRadiationExposureMethod("");
        this.zel.setMstStatus("N");
        this.zel.setMstStatusChangeDate("20020610140419-0400");
        this.zel.setMstStatusDeterminingSite("673");
        //this.zel.setAgentOrangeRegistrationDate("");
        //this.zel.setAgentOrangeExamDate("");
        //this.zel.setAgentOrangeRegistrationNumber("");
        //this.zel.setAgentOrangeExposureLocation("");
        //this.zel.setRadiationRegistrationDate("");
        //this.zel.setEnvironmentalContaminantsExamDate("");
        //this.zel.setEnvironmentalContaminantsRegistrationDate("");
        //this.zel.setMonetaryBenefitsDate("");
        this.zel.setUserEnrolleeValidThrough("20050000");
        this.zel.setUserEnrolleeSite("");
        //this.zel.setEligibilityVerificationSource("");
        //this.zel.setCombatVeteranEligibilityIndicator("");
        //this.zel.setCombatVeteranEligibilityEndDate("");

        this.zen = new ZEN();
        this.zen.setSetID("1");
        this.zen.setEnrollmentDate("19980728");
        this.zen.setEnrollmentSource("1");
        this.zen.setEnrollmentStatus("1");
        this.zen.setReason("");
        this.zen.setRemarks("");
        this.zen.setFacilityReceived("673");
        this.zen.setPreferredFacility("673BY");
        this.zen.setEnrollmentPriority("2");
        this.zen.setEffectiveDate("20041115");
        this.zen.setEnrollmentApplicationDate("20041015");
        this.zen.setEnrollmentEndDate("");
        this.zen.setEnrollmentSubGroup("");

        this.zie = new ZIE();
        this.zie.setSetID("1");
        this.zie.setIneligibleDate("20041218");
        this.zie.setIneligibleReason("SOME RANDOM REASON");
        this.zie.setIneligibleVaroDecision("MY DECISIION");
        //this.zie.setIneligibleTwxCity("");
        //this.zie.setIneligibleTwxSource("");
        //this.zie.setIneligibleTwxState("");

        this.zpd = new ZPD();
        this.zpd.setSetID("1");
        //this.zpd.setRemarks("");
        //this.zpd.setBirthCity("");
        //this.zpd.setBirthState("");
        //this.zpd.setCurrentMeansTestStatus("");
        //this.zpd.setFatherName("");
        //this.zpd.setMotherName("");
        this.zpd.setRatedIncompetent("0");
        this.zpd.setDeathDate("");
        //this.zpd.setCollateralSponsor("");
        this.zpd.setActiveHealthInsurance("0");
        this.zpd.setEligibleForMedicaid("0");
        this.zpd.setMedicaidLastAskedDate("200405191435-0400");
        //this.zpd.setRace("");
        //this.zpd.setReligion("");
        //this.zpd.setHomelessIndicator("");
        this.zpd.setPowStatusIndicated("N");
        //this.zpd.setInsuranceType("");
        this.zpd.setMedicationCopayExemptionStatus("0");
        //this.zpd.setPowConfinementLocation("");
        //this.zpd.setPrimaryCareTeam("");
        //this.zpd.setGiInsurancePolicy("");
        //this.zpd.setGiInsuranceAmount("");
        //this.zpd.setMostRecentCareDate("");
        //this.zpd.setMostRecentCareLocation("");
        //this.zpd.setSecondMostRecentCareDate("");
        //this.zpd.setSecondMostRecentCareLocation("");
        //this.zpd.setCivilIncompetentRuledDate("");
        //this.zpd.setVaIncompetentRuledDate("");
        //this.zpd.setSpinalCordInjury("");
        this.zpd.setNotificationSource("");
        this.zpd.setLastModifiedDate("");
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception
    {
        this.pid = null;
        this.zel = null;
        this.zen = null;
        this.zie = null;
        this.zpd = null;

        super.tearDown();
    }

    protected SimpleDateFormat getDateFormat()
    {
        return this.dateFormat;
    }

    protected SimpleDateFormat getDateTimeFormat()
    {
        return this.dateTimeFormat;
    }

    protected PID getPID()
    {
        return this.pid;
    }

    protected ZEL getZEL()
    {
        return this.zel;
    }

    protected ZEN getZEN()
    {
        return this.zen;
    }

    protected ZIE getZIE()
    {
        return this.zie;
    }

    protected ZPD getZPD()
    {
        return this.zpd;
    }
}