/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.xml;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/**
 * ClassPathLSResourceResolver created on Dec 8, 2006
 * @author DNS   LEV
 */
public class ClassPathLSResourceResolver implements LSResourceResolver {

   /**
    * An instance of logger 
    */
   protected Logger logger = Logger.getLogger( getClass() );
   
   /**
    * A default constructor
    */
   public ClassPathLSResourceResolver() {
      super();
   }

   /**
    * @see org.w3c.dom.ls.LSResourceResolver#resolveResource(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
    */
   public LSInput resolveResource( String type, 
                                   String namespaceURI, 
                                   String publicId, 
                                   String systemId, 
                                   String baseURI) {    
      ClassPathLSInput input = null;
      try {
         input = new ClassPathLSInput( publicId, systemId, baseURI );
      }
      catch( IOException e ) {
         if( logger.isDebugEnabled() ) {
            logger.debug( "Failed to create a ls input", e );
         }
      }
      return input;
   }

}
