/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.ls.LSInput;

/**
 * ClassPathLSInput created on Dec 8, 2006
 * @author DNS   LEV
 */
public class ClassPathLSInput implements LSInput {

   /**
    * An instance of baseURI 
    */
   private String baseURI = null;
   
   /**
    * An instance of characterStream 
    */
   private Reader characterStream = null;
   
   /**
    * An instance of byteStream 
    */
   private InputStream byteStream = null;
   
   /**
    * An instance of systemId 
    */
   private String systemId = null;
   
   /**
    * An instance of publicId 
    */
   private String publicId = null;
   
   /**
    * An instance of encoding 
    */
   private String encoding = null;
   
   /**
    * An instance of certifiedText 
    */
   public boolean certifiedText = false;
   
   /**
    * An instance of stringData 
    */
   public String stringData = null;
   
   /**
    * A default constructor
    */
   public ClassPathLSInput( String publicId, 
                            String systemId, 
                            String baseURI ) throws IOException {
      super();
      ClassPathResource resource = new ClassPathResource( systemId );
      InputStream inStream = resource.getInputStream();
      InputStreamReader reader = new InputStreamReader( inStream );
      
      this.setCharacterStream( reader );
      this.setByteStream( inStream );
      this.setBaseURI( baseURI );
      this.setSystemId( systemId );
      this.setPublicId( publicId );
      this.setStringData( null );
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getCharacterStream()
    */
   public Reader getCharacterStream() {
      return this.characterStream;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setCharacterStream(java.io.Reader)
    */
   public void setCharacterStream( Reader reader ) {
      this.characterStream = reader;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getByteStream()
    */
   public InputStream getByteStream() {
      return this.byteStream;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setByteStream(java.io.InputStream)
    */
   public void setByteStream( InputStream inStream ) {
      this.byteStream = inStream;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getStringData()
    */
   public String getStringData() {
      return this.stringData;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setStringData(java.lang.String)
    */
   public void setStringData( String data ) {
      this.stringData = data;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getSystemId()
    */
   public String getSystemId() {
      return this.systemId;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setSystemId(java.lang.String)
    */
   public void setSystemId( String id ) {
      this.systemId = id;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getPublicId()
    */
   public String getPublicId() {
      return this.publicId;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setPublicId(java.lang.String)
    */
   public void setPublicId( String id ) {
      this.publicId = id;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getBaseURI()
    */
   public String getBaseURI() {
      return this.baseURI;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setBaseURI(java.lang.String)
    */
   public void setBaseURI( String uri ) {
      this.baseURI = uri;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getEncoding()
    */
   public String getEncoding() {
      return encoding;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setEncoding(java.lang.String)
    */
   public void setEncoding( String code ) {
      this.encoding = code;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#getCertifiedText()
    */
   public boolean getCertifiedText() {
      return this.certifiedText;
   }

   /**
    * @see org.w3c.dom.ls.LSInput#setCertifiedText(boolean)
    */
   public void setCertifiedText( boolean flag ) {
      this.certifiedText = flag;
   }
}