/********************************************************************
Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.util;

// Framework classes
import gov.va.med.fw.util.NonCatastrophicException;

/** 
 * This exception is thrown during the building process of a Z11 message in 
 * case of any error that is determined to be non catastrophic in a business
 * sense.  Another word, ESR application should continue its operation as 
 * normal because this type of exception is caught and handled specically in
 * ESR application code due to specific business requirements.
 *    
 * @author  Vu Le
 * @version 1.0
 */
public class Z11NonCatastrophicException extends NonCatastrophicException {
   
   /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5419639461230634303L;

	/**
    * Creates new <code>ServiceException</code> without detail message.
    */
    public Z11NonCatastrophicException() {
      super();
   }
   
    /**
     * Creates a new <code>ServiceException</code> with the specific cause
     */
     public Z11NonCatastrophicException( Throwable cause ) {
       super(cause);
    }
     
     
   /**
    * Constructs an <code>ServiceException</code> with the specified detail message.
    * @param msg the detail message.
    */
    public Z11NonCatastrophicException(String msg) {
      super(msg);
   }
   
   /**
    * Constructs an <code>ServiceException</code> with the specified detail message
    * and a caused exception
    * @param msg the detail message.
    * @param cause the caused exception
    */
    public Z11NonCatastrophicException(String msg, Throwable cause) {
      super( msg, cause );
   }
}