/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.util;

//Java Classes
import javax.jms.Message;

//Library classes

//Framework Classes
import gov.va.med.fw.util.AbstractExceptionHandler;
import gov.va.med.fw.service.ServiceConfigurationException;

// EDB classes

/**
 * This exception handler is registered to handle ServiceConfigurationException
 * that was thrown when a JMS message is consumed by a MesssageDrivenService.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class ServiceConfigurationExceptionHandler extends AbstractExceptionHandler {

    public ServiceConfigurationExceptionHandler() {
        super();
    }

    /**
     * Handle ServiceConfigurationException that was triggered during the process
     * of an inbound message. If a service descriptor is not specified to handle
     * an inbound message, consume a message to ensure that a message will not
     * be resent for processing
     * 
     * @param exception An exception to handle
     * @param exceptionMessage An exception message
     * @param input An exception's input
     */
    public Throwable handleServiceConfigurationException( Throwable exception,
												 						    String exceptionMessage, 
																		    Object input ) {
        if( exception instanceof ServiceConfigurationException 
         && input instanceof Message ) {
            // If a service descriptor is not specified to handle a message
            // acknowledge a message to ensure that a message will be removed 
            // from a queue
            try {
                ((Message)input).acknowledge();
            }
            catch( Exception e ) {
                if( logger.isWarnEnabled() ) {
                    logger.warn( "Failed to acknowledge an invalid message was sent", e );
                }
            }
        }
        return exception;
    }
}