/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.messaging.util;

import org.apache.commons.lang.Validate;

import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.trigger.MessageCaseTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerRouter;

/**
 * Initial javadoc for class MessagingWorkloadCaseHelper.
 * TODO - Add content here
 * 
 * Created Aug 29, 2006 11:00:11 AM
 * @author DNS   BOHMEG
 */
public class MessagingWorkloadCaseHelper extends AbstractComponent {
	private LookupService lookupService;
	private TriggerRouter triggerRouter;
	
	public void afterPropertiesSet() {
		Validate.notNull(lookupService, "lookupService is required");
		Validate.notNull(triggerRouter, "triggerRouter is required");
	}
	
	public void createWorkloadCaseForCanNotRetrievePerson(PersonTriggerEvent triggerEvent, Exception e) throws ServiceException {
    	FunctionalGroup caseGroup = getLookupService().getFunctionalGroupByCode(FunctionalGroup.DQ.getCode());
    	PersonIdEntityKey key = (PersonIdEntityKey) triggerEvent.getPersonId();
    	String personKey = key.getKeyValueAsString(); 
    	if(logger.isErrorEnabled())
    		logger.error("Create ApplicationException WorkloadCase for group [" + caseGroup.getDescription() + "] and target Person [" +
    				personKey + "] for outbound Message because can not retrieve Person");
		WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
		caseInfo.setCaseType(getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_APPLICATION_EXCEPTION.getCode()));
		StringBuffer buf = new StringBuffer();
		buf.append("Unable to send outbound messages because can not retrieve Person " + personKey);
		caseInfo.setErrorMessage(buf.toString());
		caseInfo.setPersonEntityKey(key);
		caseInfo.setGroupType(caseGroup);
		
		createWorkloadCase(caseInfo, key);
	}

    public void createWorkloadCaseForConsistencyCheck(PersonIdEntityKey key, SiteIdentity siteIdentity, MessageType.Code messageTypeCode,
    		FunctionalGroup.Code groupType, String ccErrorMsgs) throws ServiceException {
    	FunctionalGroup caseGroup = getLookupService().getFunctionalGroupByCode(groupType.getCode());
    	if(logger.isErrorEnabled())
    		logger.error("Create ConsistencyCheck WorkloadCase for group [" + caseGroup.getDescription() + "] and target Person [" +
    				key.getKeyValueAsString() + "] for target Message [" + messageTypeCode.getCode() + "]");
		WorkflowCaseInfo caseInfo = new WorkflowCaseInfo();
		caseInfo.setCaseType(getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_CONSISTENCY_CHECK.getCode()));
		
		// UI only shows one field now so it was decided not to use this "generic" message
		/*StringBuffer buf = new StringBuffer();		
		buf.append("Unable to send outbound ").append(messageTypeCode.getCode());
		buf.append(" to stationNumber ").append(siteIdentity.getVaFacility().getStationNumber());
		caseInfo.setErrorMessage(buf.toString());
		// use setMessageProcessingError for potentially large CC msgs so we do not overflow setErrorMessage database column
		caseInfo.setMessageProcessingError(ccErrorMsgs);*/
		StringBuffer buf = new StringBuffer();
		buf.append(messageTypeCode.getCode()).append(": ").append(ccErrorMsgs);
		caseInfo.setErrorMessage(buf.toString()); // this should not overflow as that will be truncated by WorkflowDAO
		caseInfo.setPersonEntityKey(key);
		caseInfo.setGroupType(caseGroup);
		
		createWorkloadCase(caseInfo, key);					    	
    }
	
	public void createWorkloadCase(WorkflowCaseInfo caseInfo, PersonIdEntityKey personKey) throws ServiceException {
		// create async trigger event to create a case
		MessageCaseTriggerEvent messageCaseTriggerEvent = new MessageCaseTriggerEvent();
		messageCaseTriggerEvent.setWorkflowCaseInfo(caseInfo);
		messageCaseTriggerEvent.setPersonId(personKey);
		triggerRouter.processTriggerEvent(messageCaseTriggerEvent);
	}
	
	/**
	 * @return Returns the lookupService.
	 */
	public LookupService getLookupService() {
		return lookupService;
	}
	/**
	 * @param lookupService The lookupService to set.
	 */
	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}
	/**
	 * @return Returns the triggerRouter.
	 */
	public TriggerRouter getTriggerRouter() {
		return triggerRouter;
	}
	/**
	 * @param triggerRouter The triggerRouter to set.
	 */
	public void setTriggerRouter(TriggerRouter triggerRouter) {
		this.triggerRouter = triggerRouter;
	}
}
