/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.util;

// Java Classes
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

// Library Classes
import org.apache.commons.lang.Validate;

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class ExceptionCollectionContext
{
    private List exceptions;

    public ExceptionCollectionContext()
    {
        super();

        this.exceptions = new ArrayList();
    }

    public void addException(Exception exception)
    {
        Validate.notNull(exception, "exception cannot be null");
        this.exceptions.add(exception);
    }

    public Collection getExceptions()
    {
        return this.exceptions;
    }

    public boolean hasExceptions()
    {
        return !this.exceptions.isEmpty();
    }
}