/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.util;

// Java Classes

// Library Classes

// Framework Classes

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public abstract class AbstractExceptionCollectionContextAware
{
    private static ThreadLocal contexts = new ThreadLocal();

    protected AbstractExceptionCollectionContextAware()
    {
        super();
    }

    protected final void clearContext()
    {
        AbstractExceptionCollectionContextAware.contexts.set(null);
    }

    protected ExceptionCollectionContext createContext()
    {
        return new ExceptionCollectionContext();
    }

    protected final ExceptionCollectionContext getContext()
    {
        ExceptionCollectionContext context = (ExceptionCollectionContext)AbstractExceptionCollectionContextAware.contexts
            .get();

        if(context == null)
        {
            context = this.createContext();
            AbstractExceptionCollectionContextAware.contexts.set(context);
        }

        return context;
    }
}