/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.service.retransmission;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.hl7.builder.JMSMetaData;

// EDB classes
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;

/**
 * Project: Messaging
 * @author DNS   LEV
 * @version 1.0
 */
public class RetransmissionMessageLogBuilder extends AbstractBuilder {

    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -8591370693519241083L;
   private MessagingService messagingService = null;
    
    /**
     * A default constructor 
     */
    public RetransmissionMessageLogBuilder() {
        super();
    }

    /**
     * @see gov.va.med.fw.util.builder.Builder#build(java.lang.Object)
     */
    public Object build( JMSMetaData data ) throws BuilderException {
        
        //1. get message control id from JMS message body.
        //2. create MessageLogEntry object using MessagingService.
        //3. call resend method in the publisher object by passing MessageLogEntry.
        
        MessageLogEntry msgLog = null;
        String id = null;
        try {
            // Get a controller id
            id = data.getTextMessage();
            msgLog = this.messagingService.getMessageLogEntry( id );
        }
        catch( Exception e ) {
            if( logger.isDebugEnabled() ) {
                logger.debug( "Controller ID " + id );
                logger.debug( ToStringBuilder.reflectionToString( data ) );
            }
            throw new BuilderException( "Failed to build a message log entry from id " + id, e );
        }
        return msgLog;
    }
    
    /**
     * @return Returns the messagingService.
     */
    public MessagingService getMessagingService() {
        return messagingService;
    }
    /**
     * @param messagingService The messagingService to set.
     */
    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }
    
    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception {
        if( this.messagingService == null ) {
            throw new ServiceConfigurationException( "Missing required messaging service");
        }
    }
}