/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.retransmission;

//Framework Classes
import java.util.List;

import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.service.trigger.RetransmitTriggerEvent;

/**
 * Interface to be implemented by services that retransmit outbound messages.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public interface Retransmission {
    /**
     * Method to retransmit outbound messages.
     * 
     * @throws ServiceException
     */
    public int retransmit() throws ServiceException; 
    
    /**
     * Retransmits a collection of messages
     * 
     * @param messageLogEntries
     * @throws ServiceException
     */
    public void retransmit(List messageLogEntries) throws ServiceException;
    
    
    /**
     * Retransmits a message based on the RetransmitTriggerEvent, The trigger event
     * contains a MessageLogEntry id whose corresponding message is triggered.
     * 
     * @param retransmitTriggerEvent
     * @throws ServiceException
     */
    public void retransmit(RetransmitTriggerEvent retransmitTriggerEvent) throws ServiceException;     
    
}
