/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.retransmission;

//Framework Classes
import gov.va.med.fw.service.ServiceException;

//Common Classes
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.service.trigger.RetransmitTriggerEvent;

/**
 * Interface to be implemented by publisher classes that resend outbound messages.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public interface MessageResender {
    /**
     * Method to retransmit outbound messages.
     * 
     * @param messageLog
     *        The MessageLogEntry object to use for resending a message.
     */
    public void resend(MessageLogEntry messageLog) throws ServiceException;
    
    /**
     * @param controlId
     * @throws ServiceException
     */
    public void resend( String controlId ) throws ServiceException ;
    
    /**
     * Retransmit a specific message based on info in the RetransmitTriggerEvent
     *  
     * @param triggerEvent RetransmitTriggerEvent
     * @throws ServiceException
     */
    public void resend(RetransmitTriggerEvent triggerEvent) throws ServiceException; 
}
