/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.service.outbound;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Class to process an outbound QRYZ11 message.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class QRYZ11ProcessService extends AbstractOutboundProcessService
        implements OutboundMessageService
{

    /**
     * Default contructor.
     */
    public QRYZ11ProcessService()
    {
        super();
    }

    public void processMessage(Person person, SiteIdentity siteIdentity)
            throws ServiceException
    {
        this.processMessage(person, siteIdentity, null, null);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.service.outbound.OutboundMessageService#processMessage(gov.va.med.esr.common.model.person.Person,
     *      gov.va.med.esr.common.model.messaging.SiteIdentity,
     *      gov.va.med.fw.service.trigger.TriggerEvent)
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent) throws ServiceException
    {
        this.processMessage(person, siteIdentity, triggerEvent, null);
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.service.outbound.OutboundMessageService#processMessage(gov.va.med.esr.common.model.person.Person,
     *      gov.va.med.esr.common.model.messaging.SiteIdentity,
     *      gov.va.med.fw.service.trigger.TriggerEvent)
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            MessageLogEntry log) throws ServiceException
    {
        this.processMessage(person, siteIdentity, null, log);
    }
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent, MessageLogEntry log)
            throws ServiceException
    {
    	this.processMessage(person, siteIdentity, null, log, false);
    }
    
    /**
     * @param person
     * @param siteIdentity
     * @param triggerEvent
     * @param log
     * @param isRetransmitFromUI - if it is a retransmit for a single message from UI
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent, MessageLogEntry log, boolean isRetransmitFromUI)
            throws ServiceException
    {
        try
        {
            Message message = super.buildMessage(person);

            VAFacility receivingSite = this
                    .getLookupService()
                    .getVaFacilityByStationNumber(VAFacility.CODE_MVR.getName());

            MessageLogEntry logEntry;
            //If normal outbound message.
            if (log == null)
            {
                logEntry = super.createMessageLog(message, null, message
                        .getMessageID(), person, receivingSite, super
                        .buildTransmissionDate(message));
            } else
            { //If retransmisstion.
                logEntry = super.createMessageLog(message, null, message
                        .getMessageID(), person, receivingSite, super
                        .buildTransmissionDate(message),  
                        isRetransmitFromUI ? 0 : log.getRetransmissionCount() + 1, log);
            }

            super.logMessage(logEntry);

            super.publishMessage(message);

            if (super.logger.isInfoEnabled())
            {
                super.logger.info("Built outbound QRYZ11 with message Id " +message.getMessageID());
            }
            
        } catch (BuilderException e)
        {
            throw new ServiceException(
                    "Failed to build QRYZ11 message due to an exception", e);
        } catch (InvalidMessageException e)
        {
            //ASSERT: Should not happen if the message is already parsed.
            throw new RuntimeException(
                    "Failed to obtain data from the message", e);
        }
    }
}