package gov.va.med.esr.messaging.service.outbound;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.BuilderException;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Oct 19, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class QRYZ07ProcessService extends AbstractOutboundProcessService
        implements OutboundMessageService
{
	//CCR 11403: added so that 200ESR Correlation can be added
	private PersonService personService = null;
	
    /**
     * Default contructor.
     */
    public QRYZ07ProcessService()
    {
        super();
    }    

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.service.outbound.OutboundMessageService#processMessage(gov.va.med.esr.common.model.person.Person, gov.va.med.esr.common.model.messaging.SiteIdentity)
     */
    public void processMessage(Person person, SiteIdentity siteIdentity)
            throws ServiceException
    {
        this.processMessage(person, siteIdentity, null, null);
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.service.outbound.OutboundMessageService#processMessage(gov.va.med.esr.common.model.person.Person, gov.va.med.esr.common.model.messaging.SiteIdentity, gov.va.med.esr.common.model.messaging.MessageLogEntry)
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            MessageLogEntry log) throws ServiceException
    {
        this.processMessage(person, siteIdentity, null, log);
    }

    /* (non-Javadoc)
     * @see gov.va.med.esr.messaging.service.outbound.OutboundMessageService#processMessage(gov.va.med.esr.common.model.person.Person, gov.va.med.esr.common.model.messaging.SiteIdentity, gov.va.med.esr.service.trigger.PersonTriggerEvent)
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent) throws ServiceException
    {
        this.processMessage(person, siteIdentity, triggerEvent, null);
    }
    
    /**
     * @param person
     * @param siteIdentity
     * @param triggerEvent
     * @param log
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent, MessageLogEntry log)
            throws ServiceException
    {
    	//CCR 11758: in gov.va.med.esr.messaging.service.outbound.OutboundPersonMessageRouter.getPerson(PersonTriggerEvent),
    	//QRYZ07 message uses composite call to get the person. So here we can use has200ESRCorrelation() to determine
        if (person.getIdentityTraits() != null && "N".equals(person.getIdentityTraits().has200ESRCorrelation()))
        	this.getPersonService().addESRCorrelation(person);
        
    	this.processMessage(person, siteIdentity, triggerEvent, log, false);
    }
    /**
     * @param person
     * @param siteIdentity
     * @param triggerEvent
     * @param log
     * @param isRetransmitFromUI - if it is a retransmit for a single message from UI 
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent, MessageLogEntry log, boolean isRetransmitFromUI)
            throws ServiceException
    {
        if (super.logger.isInfoEnabled())
        {
            super.logger.info("Building outbound QRYZ07");

            if (person.getEntityKey() != null)
            {
                super.logger.info("Person id = " + person.getEntityKey());
            }
        }

        try
        {
        	IncomeYearTriggerEvent incomeYearEvent = (IncomeYearTriggerEvent) triggerEvent;
            Object[] args = new Object[] { person, siteIdentity, incomeYearEvent.getIncomeYear()};            
            Message message = super.buildMessage(args);
            
            VAFacility receivingSite = siteIdentity.getVaFacility();

            MessageLogEntry logEntry;
            //If normal outbound message.
            if (log == null)
            {
                logEntry = super.createMessageLog(message, null, message
                        .getMessageID(), person, receivingSite, super
                        .buildTransmissionDate(message));
            } else
            { //If retransmisstion.
                logEntry = super.createMessageLog(message, null, message
                        .getMessageID(), person, receivingSite, super
                        .buildTransmissionDate(message), 
                        isRetransmitFromUI ? 0 : log.getRetransmissionCount() + 1, log);
            }

            super.logMessage(logEntry);

            super.publishMessage(message);

            if (super.logger.isInfoEnabled())
            {
                super.logger.info("Built outbound QRYZ07 with message ID " +message.getMessageID());
            }
        } catch (BuilderException e)
        {
            throw new ServiceException(
                    "Failed to build QRYZ07 message due to an exception", e);
        } catch (InvalidMessageException e)
        {
            //ASSERT: Should not happen if the message is already parsed.
            throw new RuntimeException(
                    "Failed to obtain data from the message", e);
        }
    }

	public PersonService getPersonService() {
		return personService;
	}

	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}    

}
