/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Framework Classes
import gov.va.med.fw.service.ServiceException;

//ESR Classes
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Alex Yoon
 * @version 1.0
 */
public class OutboundMessageVbaAdaptor extends AbstractOutboundServiceAdaptor {
    /**
     * Default constructor.
     */
    public OutboundMessageVbaAdaptor() {
        super();
    }
    
    /**
     * Method to process an outbound message.  
     * 
     * @param input
     *        The input used to build a message.
     * @throws ServiceException
     */
    public void processMessage(Object input) throws ServiceException {
        Object[] args = (Object[])input;

        this.processMessage((Person)args[0], (String)args[1]);
    }
    
    /**
     * Method to process an outbound message.  This method gets corresponding 
     * OutboundProcessService for message type and delegates actual creation of
     * outbound messages to the appropriate service.
     * 
     * @param person
     *        The person used to build a message.
     * @param messageType
     * 		  The messageType used to build a message.
     * 
     * @throws ServiceException
     */
    public void processMessage(Person person, String messageType) throws ServiceException {
        OutboundMessageService service = this.getOutboundService(messageType);
        
        if (logger.isDebugEnabled()) {
			logger.debug("Got a Service " + service.getClass().getName()
			        + " for Message Type " + messageType);
		}
        
        //Passing null for siteIdentity parameter since the specific OutboundMessageService
        //already knows message is being sent to a specific site (AAC).
        service.processMessage(person, null);
    }
}
