/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Framework Classes
import gov.va.med.fw.service.ServiceException;

//Common Classes
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;


/**
 * Interface to be implemented by outbound message process services.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public interface OutboundMessageService {
    /**
     * Method to process an outbound message.
     * 
     * @param person
     *        The person to build a message for.
     * @param site
     *        The site to send a message.
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity site) throws ServiceException;
    
    /**
     * Method to process an outbound message for retransmission.
     * 
     * @param person
     *        The person to build a message for.
     * @param site
     *        The site to send a message.
     * @param log
     *        The message log entry to send a message for.
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity site, MessageLogEntry log) throws ServiceException;
    
    /**
     * Method to process an outbound message. Contains a TriggerEvent as param which can be inspected to get
     * specific TriggerEventData. For e.g data type like a ORUZ05 trigger due to Address change OR GuardianInfo change,
     * what are the entities that got updated e.g Address entity key for a ORUZ05.
     * 
     * 
     * @param person
     * @param site
     * @param triggerEvent
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity site, PersonTriggerEvent triggerEvent) throws ServiceException;
    
    /**
     * Method to process an outbound message. Contains a TriggerEvent as param which can be inspected to get
     * specific TriggerEventData. For e.g data type like a ORUZ05 trigger due to Address change OR GuardianInfo change,
     * what are the entities that got updated e.g Address entity key for a ORUZ05.
     * MessageLogEntry - In case of retransmission, the original message log entry will be present
     * 
     * @param person
     * @param siteIdentity
     * @param triggerEvent
     * @param incomingLogEntry
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent, MessageLogEntry incomingLogEntry)
            throws ServiceException;
    
    /**
     * Method to process an outbound message. Contains a TriggerEvent as param which can be inspected to get
     * specific TriggerEventData. For e.g data type like a ORUZ05 trigger due to Address change OR GuardianInfo change,
     * what are the entities that got updated e.g Address entity key for a ORUZ05.
     * MessageLogEntry - In case of retransmission, the original message log entry will be present
     * 
     * @param person
     * @param siteIdentity
     * @param triggerEvent
     * @param incomingLogEntry
     * @param isRetransmitFromUI - if it is a retransmit for a single message from UI
     * @throws ServiceException
     */
    public void processMessage(Person person, SiteIdentity siteIdentity,
            PersonTriggerEvent triggerEvent, MessageLogEntry incomingLogEntry, boolean isRetransmitFromUI)
            throws ServiceException;    
}
