/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Framework Classes
import gov.va.med.fw.service.ServiceException;

//Common Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;

/**
 * Interface to be implemented by outbound Mastee message process services.
 * @author Alex Yoon
 * @version 1.0
 */
public interface OutboundMessageMasterFileService {
    /**
     * Method to process an outbound message.
     * 
     * @param obj
     *        The Object to build a message for.
     * @param site
     *        The site to send a message.
     * @throws ServiceException
     */
    public void processMessage(Object obj, VAFacility site) throws ServiceException;
    
    /**
     * Method to process an outbound message for retransmission.
     * 
     * @param obj
     *        The Object to build a message for.
     * @param site
     *        The site to send a message.
     * @param log
     *        The message log entry to send a message for.
     * @throws ServiceException
     */
    public void processMessage(Object obj, VAFacility site, MessageLogEntry log) throws ServiceException;
}
