/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

//Java Classes
import java.util.Map;

//Framework Classes
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.InvalidConfigurationException;

/**
 * Abstract class that should be extended by outbound adaptor services.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public abstract class AbstractOutboundServiceAdaptor extends AbstractComponent implements OutboundProcessService {
    /**
	 * Configuration injected as such: Map<Message Type, OutboundProcessService>
	 */
	protected Map outboundProcessServices;
	
	/**
     * Default constructor.
     */
    public AbstractOutboundServiceAdaptor()
    {
        super();
    }
    
	/**
	 * @return Returns the outboundProcessServices.
	 */
	public Map getOutboundProcessServices() {
		return outboundProcessServices;
	}

	/**
	 * @param outboundProcessServices
	 *        The outboundProcessServices to set.
	 */
	public void setOutboundProcessServices(Map outboundProcessServices) {
		this.outboundProcessServices = outboundProcessServices;
	}
	
	/**
     * Method to OutboundMessageService bean through Mapping.
     * 
     * @param messageType
     *        The input used to find a corresponding OutboundMessageService.
     * @throws ServiceException
     */
	public OutboundMessageService getOutboundService(String messageType) {
	    OutboundMessageService service = (OutboundMessageService)outboundProcessServices.get(messageType);
	    
	    if (service == null) {
	        throw new InvalidConfigurationException(messageType
	                + " not mapped to an OutboundProcessService");
	    }
	    
	    return service;
	}
	
	public void afterPropertiesSet() {
		if(outboundProcessServices == null)
			throw new InvalidConfigurationException("Map of OutboundProcessServices must be set on " + getClass().getName());
	}
}
