/********************************************************************
 * Copyright  2004 EDS. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.esr.messaging.service.outbound;

// Java Classes
import java.util.List;

import org.apache.commons.lang.ClassUtils;

// Library Classes

// Framework Classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StopWatchLogger;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.hl7.Message;

// Common Classes

// Messaging Classes

/**
 * Class to process ACK (AE type) message.
 * 
 * @author Alex Yoon
 * @version 1.0
 */
public class ACKAEProcessService
    extends AbstractOutboundProcessService implements OutboundProcessService {
    
    public ACKAEProcessService()
    {
        super();
    }

    public void processMessage(Object input) throws ServiceException
    {
        Object[] args = (Object[])input;

        this.processMessage((Message)args[0], (List)args[1]);
    }

    /**
     * Method to process the ACK message.
     * 
     * @param message
     */
    public void processMessage(Message message, List errors)
        throws ServiceException
    { 
    	StopWatchLogger watch = null;     	
    	if(logger.isDebugEnabled())
    	{
	        watch = new StopWatchLogger( ClassUtils.getShortClassName( getClass() ) + " processMessage" );
	        watch.start();
    	}
        if(super.logger.isInfoEnabled())
        {
            super.logger.info("Building outbound AE ACK Message");
        }

        try
        {
            Message ackMessage = super.buildMessage(new Object[] { message,
                    errors });

            super.publishMessage(ackMessage);
        }
        catch(BuilderException e)
        {
            throw new ServiceException(
                "Failed to build an ACK message due to an exception ", e);
        }finally{
        	if(logger.isDebugEnabled() && watch != null)        	
        		watch.stopAndLog();
        }
    }
}