/*
 * Created on Nov 9, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.messaging.service.jms;

//Java Classes
import java.util.Properties;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.QueueMessageProducerService;

import gov.va.med.esr.messaging.constants.HL7Constants;

/**
 * @author vhaivmngvs
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ProducerService extends QueueMessageProducerService{
    
    /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = -1794147744858004744L;

   /**
     * 
     */
    public ProducerService() {
        super();
        // TODO Auto-generated constructor stub
    }
    
    /**
     * Method to build the message properties object that is needed to send 
     * a JMS message.
     * 
     * @param message
     * @return
     */
    private Properties buildMessageProperties(Message message) {
        try {
            Properties props = new Properties();
            props.put(HL7Constants.MESSAGE_ID, message.getMessageID());
            props.put(HL7Constants.RECEIVING_SITE, (String) message.getReceivingFacility());   //getSegment(HL7Constants.BHS).getElements().get(3));
            props.put(HL7Constants.RECEIVING_APPLICATION, message.getReceivingApplication());
            
            return props;
        }
        catch (InvalidMessageException e) {
            //ASSERT: Should not happen if the message is already parsed.
            throw new RuntimeException( "Failed to build the JMS message properties", e);
        }
    }
    
    /**
     * Method to determine the appropriate message type and delegate to the appropriate property message builder and call the message producer servicer sender
     * 
     * 
     * @param object
     * @return QueueSession
     */
    
    public void send(Message message)throws ServiceException
    {
        Properties props = null;	
        try
        {
            props = buildMessageProperties(message);
            super.send(message,props);
        }
        catch (ServiceException ex)
        {
            throw ex;
        }
    }
}
