/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.service.jms;

// Java Classes
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.messaging.service.MessagePublisher;

/**
 * @author Martin Francisco
 */
public class JmsMessagePublisher
    extends AbstractComponent
    implements MessagePublisher
{
    private ProducerService producerService;

    /**
     * Default constructor.
     */
    public JmsMessagePublisher()
    {
        super();
    }

    /**
     * @return Returns the producerService.
     */
    public ProducerService getProducerService()
    {
        return this.producerService;
    }

    /**
     * @param producerService
     *        The producerService to set.
     */
    public void setProducerService(ProducerService producerService)
    {
        this.producerService = producerService;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.service.MessagePublisher#publish(gov.va.med.fw.hl7.Message)
     */
    public void publish(Message message) throws ServiceException
    {
        this.producerService.send(message);
    }
}