package gov.va.med.esr.messaging.service.inbound;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Contains inbound Z12 message specific logic. - Calls Z12Z13 Parser to build a
 * Person from the message data - Invokes Z12 specific rule flow.
 * 
 * @author Rajiv Patnaik Created on Dec 19, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class Z12ProcessService extends AbstractInboundProcessService
{

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.service.inbound.AbstractInboundProcessService#doProcessMessage(gov.va.med.esr.common.model.person.Person,
     *      gov.va.med.fw.hl7.Message, java.lang.String)
     */
    protected MessageLogEntry doProcessMessage(Person person, Message message,
            String formattedBody) throws InboundProcessException
    {
        try
        {
            //Call Z12Z13Parser to build a Person from the message
            person = buildPerson(person, message);

            VAFacility sendingFacility = getLookupService()
                    .getVaFacilityByStationNumber(message.getSendingFacility());

            //Invoke Rules
            person = getMessagingService().processORUZ12(person,
                    sendingFacility);

            return super.createMessageLog(message, formattedBody, person);
        } catch (BuilderException e)
        {
            throw super.createInboundProcessException(message, formattedBody,
                    person, e.getMessage(), e);
        } catch (Exception e)
        {
            throw super.createInboundProcessException(message, formattedBody,
                    person, e.getMessage(), e);
        }
    }

}