package gov.va.med.esr.messaging.service.inbound;

import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * 
 * @author Rajiv Patnaik Created on Sep 27, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class Z05ProcessService extends AbstractInboundProcessService
{
    private MessagingService messagingService;

    /**
     * Default constructor.
     */
    public Z05ProcessService()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.service.inbound.AbstractInboundProcessService#doProcessMessage(gov.va.med.esr.common.model.person.Person,
     *      gov.va.med.fw.hl7.Message, java.lang.String)
     */
    protected MessageLogEntry doProcessMessage(Person person, Message message,
            String formattedBody) throws InboundProcessException
    {
        try
        {
            //Call Z05Parser to build a Person from the message
            person = buildPerson(person, message);
            
            //Invoke Rules
            person = messagingService.processORUZ05(person);

            return super.createMessageLog(message, formattedBody, person);
        } catch (BuilderException e)
        {
            throw super.createInboundProcessException(message, formattedBody,
                    person, e.getMessage(), e);
        } catch (Exception e)
        {
            throw super.createInboundProcessException(message, formattedBody,
                    person, e.getMessage(), e);
        }
    }

    /**
     * @return Returns the messagingService.
     */
    public MessagingService getMessagingService()
    {
        return messagingService;
    }
    /**
     * @param messagingService The messagingService to set.
     */
    public void setMessagingService(MessagingService messagingService)
    {
        this.messagingService = messagingService;
    }
}