package gov.va.med.esr.messaging.service.inbound;

import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.QRD;

/**
 * Processes the inbound QRYZ11 message from Vista.
 * 
 * @author Rajiv Patnaik
 * Created on Jan 10, 2006
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class QRYZ11InboundProcessService extends AbstractQRYInboundProcessService
{

	protected void doProcessQRYMessage(Person person, Message message, IncomingMessageInfo messageInfo) 
		throws Exception 
	{
        getMessagingService().processQRYZ11(person, messageInfo); 
	}

}
