package gov.va.med.esr.messaging.service.inbound;

import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.hl7.segment.QRD;

/**
 * Contains inbound QRYZ10message specific logic. 
 * 
 * @author Rajiv Patnaik
 * Created on Dec 21, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class QRYZ10InboundProcessService extends AbstractQRYInboundProcessService
{
	
	protected void doProcessQRYMessage(Person person, Message message, IncomingMessageInfo messageInfo) 
		throws Exception 
	{
		
        QRD qrd = (QRD)message.getSegment("QRD");

        String departmentDataCode = qrd.getWhatDepartmentDataCode();
        Integer incomeYear = Integer
                .valueOf(departmentDataCode == null ? null
                        : departmentDataCode.substring(0, 4));

        getMessagingService().processQRYZ10(person,incomeYear, messageInfo); 

	}

}
