/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.messaging.service.inbound;

// Java Classes

// Library Classes

// Framework Classes
import org.apache.commons.lang.Validate;

import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.messaging.service.AbstractMessagingService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;

/**
 * @author Martin Francisco
 */
public class PersonFinderFromSolicitedMessage
    extends AbstractMessagingService
    implements PersonFinder
{
    private PersonService personService;    
	private PSDelegateService psDelegateService;
	
    public PersonFinderFromSolicitedMessage()
    {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.messaging.service.inbound.PersonFinder#find(gov.va.med.fw.hl7.Message)
     */
    public Person find(Message message) throws ServiceException
    {
        MessageLogEntry originalMessageEntry = super
                .getReferencedMessageLogEntry(message);

        Person person = null;

        if (originalMessageEntry != null && originalMessageEntry.getPersonId() != null)
        {
                //No need to re-retrieve the full Person, all we need is
                //identity traits. However there is no API that retrieves the 
                //Person Traits only
                person = getPersonService().getPerson(
                        CommonEntityKeyFactory
                                .createPersonIdEntityKey(originalMessageEntry
                                        .getPersonId().toString()));
        }
        return person;
    }

	
	public void afterPropertiesSet() {
		Validate.notNull(psDelegateService);
	}

	
	
    /**
     * @return Returns the personService.
     */
    public PersonService getPersonService()
    {
        return personService;
    }
    /**
     * @param personService The personService to set.
     */
    public void setPersonService(PersonService personService)
    {
        this.personService = personService;
    }
	/**
	 * @return Returns the psDelegateService.
	 */
	public PSDelegateService getPsDelegateService() {
		return psDelegateService;
	}

	/**
	 * @param psDelegateService The psDelegateService to set.
	 */
	public void setPsDelegateService(PSDelegateService psDelegateService) {
		this.psDelegateService = psDelegateService;
	}
}