package gov.va.med.esr.messaging.service.inbound;

import gov.va.med.fw.hl7.Message;

import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;

/**
 * Interface to be implemented by services that process inbound messages.
 * 
 * @author Martin Francisco
 */
public interface InboundProcessService
{		
    public MessageType getMessageType();

    /**
     * Method to process inbound message.
     * 
     * @param message
     * @throws InboundProcessException
     */
    public MessageLogEntry processMessage(Message message)
        throws InboundProcessException;
}