/*******************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.messaging.service.inbound;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;

// Common Classes
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.messaging.MsdsErrorLogEntry;

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class InboundProcessException extends ServiceException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7735704361939890985L;

	private MessageLogEntry logEntry;
	private MsdsErrorLogEntry msdsErrorLogEntry;
	
	//Temporary attribute.
	//Added to send the TriggerEvent back to the caller which can then route it.
	//Will be removed once the RollbackAdvice handles Spring declarative transactional 
	//handling for all exceptions
	private TriggerEvent triggerEvent;
	
	

	/**
	 * @param logEntry
	 */
	public InboundProcessException(MessageLogEntry logEntry) {
		super();
		this.logEntry = logEntry;
	}

	
	/**
	 * @param logEntry
	 * @param msg
	 */
	public InboundProcessException( MessageLogEntry logEntry, String msg ) {
		super(msg);
		this.logEntry = logEntry;
	}

	/**
	 * @param logEntry
	 * @param msg
	 * @param cause
	 */
	public InboundProcessException( MessageLogEntry logEntry, 
											  String msg,
											  Throwable cause) {
		super(msg, cause);
		this.logEntry = logEntry;
	}

	public MessageLogEntry getLogEntry() {
		return this.logEntry;
	}
	
	public InboundProcessException( MsdsErrorLogEntry logEntry, String process, 
			String msg,
			Throwable cause) {
		super(msg, cause);
		this.msdsErrorLogEntry = logEntry;
	}

	public MsdsErrorLogEntry getMsdsErrorLogEntry() {
		return this.msdsErrorLogEntry;
	}
	
	
    /**
     * @return Returns the triggerEvent.
     */
    public TriggerEvent getTriggerEvent()
    {
        return triggerEvent;
    }
    /**
     * @param triggerEvent The triggerEvent to set.
     */
    public void setTriggerEvent(TriggerEvent triggerEvent)
    {
        this.triggerEvent = triggerEvent;
    }
}