/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.messaging.service.inbound;

import org.apache.commons.lang.Validate;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

/**
 * Initial javadoc for class AbstractPersonFinderFromVista.
 * TODO - Add content here
 * 
 * Created Nov 7, 2006 4:50:17 PM
 * @author DNS   BOHMEG
 */
public abstract class AbstractPersonFinderFromVista extends AbstractComponent implements
		PersonFinder {
	private PSDelegateService psDelegateService;
    private PersonService personService;
    protected static final String PERSON_NOT_FOUND_ERR = "Person not found";
    
    protected Person getPerson(String dfn, String stationNumber) throws ServiceException {
    	try {
	    	/*PersonIdentityTraits identityTraits = this.psDelegateService.getIdentityTraits(dfn, stationNumber);*/  //legacy	
    		//CCR11776
	    	PersonIdentityTraits identityTraits = this.psDelegateService.getIdentityTraitsWithCompositeCall(dfn,stationNumber);
	
	        return this.personService.find(identityTraits);
    	} catch(Exception e) {
            //Catch and set the message to "Person not found". That will be the 
            //message to be sent in the AE
            throw new ServiceException(PERSON_NOT_FOUND_ERR, e);
    	}
    }
    
	/**
	 * Return the sending facility station number.
	 * 
	 * @param message
	 * @return The sending facility station number.
	 */
	protected final String getSendingFacilityStationNumber(Message message) {
		try {
			return message.getSendingFacility();
		} catch (InvalidMessageException e) {
			// ASSERT: Should not happen if the message is already parsed.
			throw new RuntimeException(
					"Failed to obtain the station number from the MSH segment",
					e);
		}
	}    
    
	/**
	 * @return Returns the personService.
	 */
	public PersonService getPersonService() {
		return personService;
	}

	/**
	 * @param personService The personService to set.
	 */
	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}

	/**
	 * @return Returns the psDelegateService.
	 */
	public PSDelegateService getPsDelegateService() {
		return psDelegateService;
	}

	/**
	 * @param psDelegateService The psDelegateService to set.
	 */
	public void setPsDelegateService(PSDelegateService psDelegateService) {
		this.psDelegateService = psDelegateService;
	}

	public void afterPropertiesSet() {
		Validate.notNull(psDelegateService, "psDelegateService is required");
		Validate.notNull(personService, "personService is required");
	}	
}
